﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

#Region "事件处理程序"
    Private CurrentMessageType As TraceEventType
    Private Shared LogDirectory As String = "C:\temp\logs\"


    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        For Each enabledListener As TraceListener In My.Application.Log.TraceSource.Listeners
            Me.DataGridView1.Rows.Add(enabledListener.GetType.FullName)
        Next
    End Sub

    Private Sub InformationRadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles InformationRadioButton.CheckedChanged
        Me.CurrentMessageType = TraceEventType.Information
    End Sub

    Private Sub WarningRadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WarningRadioButton.CheckedChanged
        Me.CurrentMessageType = TraceEventType.Warning
    End Sub

    Private Sub ErrorRadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ErrorRadioButton.CheckedChanged
        Me.CurrentMessageType = TraceEventType.Error
    End Sub

    Private Sub CriticalRadioButton_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CriticalRadioButton.CheckedChanged
        Me.CurrentMessageType = TraceEventType.Critical
    End Sub
#End Region

    Private Sub WriteMessageButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles WriteMessageButton.Click
        If (Me.MessageTextBox.Text <> String.Empty) Then
            My.Application.Log.WriteEntry(Me.MessageTextBox.Text, Me.CurrentMessageType)
            ' 刷新所有的侦听器。出于对性能的考虑，通常不应在成品应用程序中执行此操作。
            ' 在这里执行此操作是为了您可以在执行示例期间查看日志文件。
            ' 
            My.Application.Log.TraceSource.Flush()
            Me.MessageTextBox.Text = String.Empty
        End If
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class